<?php $__env->startSection('title', 'Bebidas' . ' | ' . config('app.name')); ?>

<?php $__env->startSection('content_header'); ?>
    <div class="w-100">

        <?php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Bebidas', 'route' => 'bebidas.index'],
                ['name' => 'Lista de Bebidas'],
            ];
        ?>

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($breadcrumb['route'])): ?>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route($breadcrumb['route'])); ?>">
                                <?php if(isset($breadcrumb['icon'])): ?>
                                    <i class="fas <?php echo e($breadcrumb['icon']); ?> mr-1"></i>
                                <?php endif; ?>
                                <?php echo e($breadcrumb['name']); ?>

                            </a>
                        </li>
                    <?php else: ?>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($breadcrumb['name']); ?></li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        </nav>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="m-0">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <!-- Título -->
                            <div class="col-12 col-md-6 mb-2 mb-md-0">
                                <h5 class="mb-0">Gestión de Bebidas</h5>
                            </div>

                            <!-- Select + Botón -->
                            <div class="col-12 col-md-6">
                                <div class="row">
                                    <div class="col-12 col-md-8 mb-2 mb-md-0">
                                        <select id="filtroCarta" class="form-control form-control-sm">
                                            <option value="">Todas las cartas</option>
                                            <?php $__currentLoopData = $cartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($carta->id); ?>">
                                                    <?php echo e($carta->translate(app()->getLocale())->nombre ?? $carta->id); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-4 text-md-right">
                                        <button type="button" class="btn btn-success btn-sm w-100 w-md-auto"
                                            id="btnNuevoBebida">
                                            <i class="fas fa-plus"></i> Nuevo Bebida
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>



                    </div>
                    <div class="card-body p-2">


                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">

                                        <div class="card-body">
                                            <div class="row mb-3">


                                            </div>

                                            <!-- Cards agrupadas por carta -->
                                            <div id="bebidas-container">
                                                <?php $__currentLoopData = $cartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="carta-group mb-4" data-carta-id="<?php echo e($carta->id); ?>">
                                                        <h3 class="border-bottom pb-2 mb-3">
                                                            <i class="fas fa-folder me-2"></i>
                                                            <?php echo e($carta->translate(app()->getLocale())->nombre ?? 'Carta ' . $carta->id); ?>

                                                        </h3>
                                                        <div class="row bebidas-row" id="bebidas-carta-<?php echo e($carta->id); ?>">
                                                            <!-- Los bebidas se cargarán via AJAX -->
                                                            <div class="col-12 text-center">
                                                                <div class="spinner-border text-primary" role="status">
                                                                    <span class="sr-only">Cargando...</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Modal para agregar/editar -->
                        <?php echo $__env->make('bebidas.modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                        <!-- Modal para ver detalles -->

                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <style>
        .carta-group {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            border-left: 4px solid #007bff;
        }

        .bebida-card {
            transition: transform 0.2s;
            height: 100%;
        }

        .bebida-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .bebida-imagen {
            height: 200px;
            object-fit: cover;
        }

        .badge-alergeno {
            font-size: 0.7em;
            margin: 2px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $('#carta_id').on('change', function() {
            let cartaId = $(this).val();

            if (cartaId) {
                $.get('/admin/cartas/' + cartaId + '/subcartas', function(data) {
                    let $subCarta = $('#sub_carta_id');
                    $subCarta.empty().append('<option value="">-- Seleccione SubCarta --</option>');

                    $.each(data, function(i, subcarta) {
                        $subCarta.append('<option value="' + subcarta.id + '">' + subcarta.nombre +
                            '</option>');
                    });
                });
            } else {
                $('#sub_carta_id').empty().append('<option value="">-- Seleccione SubCarta --</option>');
            }
        });
    </script>
    <script>
        $(document).on('click', '#btnNuevoBebida', function() {
            // Limpiar formulario
            $('#bebidaForm')[0].reset();
            // Abrir modal
            $('#bebidaModal').modal('show');
            $('.modal-title').text('Nuevo Bebida'); // 👈 agrega texto al título del modal
        });
        // Configurar CSRF token
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            // Cargar bebidas iniciales
            loadBebidasByCarta();

            // Filtro por carta
            $('#filtroCarta').on('change', function() {
                const cartaId = $(this).val();

                if (cartaId) {
                    $('.carta-group').hide();
                    $(`.carta-group[data-carta-id="${cartaId}"]`).show();
                } else {
                    $('.carta-group').show();
                }
            });

            // Cargar bebidas por carta
            function loadBebidasByCarta() {
                <?php $__currentLoopData = $cartas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $carta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    $.ajax({
                        url: "<?php echo e(route('bebidas.byCarta', ':id')); ?>".replace(':id', '<?php echo e($carta->id); ?>'),
                        type: 'GET',
                        success: function(response) {
                            if (response.success) {
                                renderBebidas(response.carta, response.bebidas);
                            }
                        },
                        error: function(xhr) {
                            console.error('Error loading bebidas:', xhr);
                            $('#bebidas-carta-<?php echo e($carta->id); ?>').html(`
                    <div class="col-12">
                        <div class="alert alert-danger">
                            Error al cargar los bebidas
                        </div>
                    </div>
                `);
                        }
                    });
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            }

            // Renderizar bebidas en cards
            // helper para escapar texto y evitar XSS
            function escapeHtml(text) {
                if (!text && text !== 0) return '';
                return String(text)
                    .replace(/&/g, '&amp;')
                    .replace(/</g, '&lt;')
                    .replace(/>/g, '&gt;')
                    .replace(/"/g, '&quot;')
                    .replace(/'/g, '&#039;');
            }

            // Renderizar bebidas en cards (actualizado para precios desde bebida.precios)
            function renderBebidas(carta, bebidas) {
                const container = $('#bebidas-carta-' + carta.id);

                if (!Array.isArray(bebidas) || bebidas.length === 0) {
                    container.html(`
            <div class="col-12">
                <div class="alert alert-info">
                    No hay bebidas en esta carta
                </div>
            </div>
        `);
                    return;
                }

                const tiposOrden = ['copa', 'vaso', 'botella', 'chupito'];
                const labels = {
                    copa: 'Copa',
                    vaso: 'Vaso',
                    botella: 'Botella',
                    chupito: 'Chupito'
                };

                let html = '';

                bebidas.forEach(bebida => {
                    // Construir HTML de precios solo para presentaciones con valor válido (>0)
                    let priceHtml = '';
                    if (Array.isArray(bebida.precios) && bebida.precios.length > 0) {
                        tiposOrden.forEach(tipo => {
                            // Maneja posibles keys: tipo_presentacion o tipo
                            const p = bebida.precios.find(x => (x.tipo_presentacion || x.tipo) ===
                                tipo);
                            const valor = p ? (p.precio ?? p.price ?? null) : null;
                            const num = (valor !== null && valor !== '') ? Number(valor) : NaN;
                            if (!isNaN(num) && isFinite(num) && num > 0) {
                                priceHtml +=
                                    `<div><strong>${labels[tipo]}: €${num.toFixed(2)}</strong></div>`;
                            }
                        });
                    }

                    // Fallback: si backend no envía precios pero existe bebida.precio, mostrarlo (opcional)
                    if (!priceHtml && bebida.precio !== undefined && bebida.precio !== null && !isNaN(
                            Number(bebida.precio))) {
                        priceHtml =
                            `<div><strong>Precio: €${parseFloat(bebida.precio).toFixed(2)}</strong></div>`;
                    }

                    html += `
            <div class="col-md-4 mb-4">
                <div class="card bebida-card">
                    <img src="/${escapeHtml(bebida.imagen || 'images/no_image.jpg')}" 
                        class="card-img-top bebida-imagen" 
                        alt="${escapeHtml(bebida.nombre)}">
                    <div class="card-body">
                        <h5 class="card-title">${escapeHtml(bebida.nombre)}</h5>
                        <p class="card-text text-muted">${escapeHtml(bebida.descripcion || 'Sin descripción')}</p>

                        ${ priceHtml ? `<div class="mb-2">${priceHtml}</div>` : '' }

                        ${ (bebida.alergenos && bebida.alergenos.length > 0) ? `
                                <div class="mb-2">
                                    <small class="text-muted">Alérgenos:</small>
                                    <div>
                                        ${bebida.alergenos.map(a => `<span class="badge badge-warning badge-alergeno">${escapeHtml(a.nombre)}</span>`).join(' ')}
                                    </div>
                                </div>
                            ` : '' }

                        <div class="btn-group btn-group-sm">
                            <button class="btn btn-warning btn-editar" data-id="${bebida.id}">
                                <i class="fas fa-edit"></i> Editar
                            </button>
                            <button class="btn btn-danger btn-eliminar" data-id="${bebida.id}">
                                <i class="fas fa-trash"></i> Eliminar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        `;
                });

                container.html(html);
            }


            $('#bebidaForm').on('submit', function(e) {
                e.preventDefault();
                let formData = new FormData(this);

                $.ajax({
                    url: '<?php echo e(route('bebidas.store')); ?>',
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(res) {
                        if (res.success) {
                            $('#bebidaModal').modal('hide');
                            Toast.fire({
                                icon: 'success',
                                title: res.message
                            });
                            // 👇 refrescar bebidas dinámicamente
                            loadBebidasByCarta();
                        } else {
                            Toast.fire({
                                icon: 'error',
                                title: res.message
                            });
                        }
                    },
                    error: function(xhr) {
                        Toast.fire({
                            icon: 'error',
                            title: xhr.responseJSON?.message || 'Error al guardar'
                        });
                    }
                });
            });
            // Resto del código para el modal y acciones (similar al de alergenos)
            // ... [Aquí iría el código JavaScript para manejar el modal, similar al ejemplo anterior de alergenos]

            // Eliminar
            $(document).on('click', '.btn-eliminar', function() {
                let id = $(this).data('id');

                Swal.fire({
                    title: '¿Está seguro?',
                    text: "Esta bebida será eliminada",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Sí, eliminar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '/admin/bebidas/' + id,
                            method: 'DELETE',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>'
                            },
                            success: function(res) {
                                Toast.fire({
                                    icon: 'success',
                                    title: res.message
                                });

                                // 👇 Recargamos las bebidas
                                loadBebidasByCarta();
                            },
                            error: function(xhr) {
                                console.error(xhr.responseText);
                                Toast.fire({
                                    icon: 'error',
                                    title: 'Error al eliminar'
                                });
                            }
                        });
                    }
                });
            });
        });
    </script>

    <script>
       
        $(document).on('click', '.btn-ver', function() {
            let id = $(this).data('id');

            $.get(`/admin/bebidas/${id}`, function(data) {
                $('#detalle-carta').text(data.carta ?? '-');
                $('#detalle-subcarta').text(data.subcarta ?? '-');
                $('#detalle-precio').text(data.precio + ' €');
                $('#detalle-orden').text(data.orden);
                $('#detalle-activo').text(data.activo ? 'Activo' : 'Inactivo');
                $('#detalle-alergenos').text(data.alergenos.join(', ') || '-');
                $('#detalle-nombre').text(data.nombre ?? '-');
                $('#detalle-descripcion').text(data.descripcion ?? '-');

                if (data.imagen) {
                    $('#detalle-imagen').html(
                        `<img src="${data.imagen_url}" class="img-thumbnail" width="200">`
                    );
                } else {
                    $('#detalle-imagen').html('');
                }

                $('#verBebidaModal').modal('show');
            });
        });

        // Nuevo bebida
        $('#btnNuevo').on('click', function() {
            $('#bebidaForm')[0].reset();
            $('#bebida_id').val('');
            $('#imagen-preview').html('');
            $('#eliminar-imagen-container').hide();
            $('.modal-title').text('Nuevo Bebida'); // 👈 agrega texto al título del modal
        });
        // Editar
        $(document).on('click', '.btn-editar', function() {
            $('.modal-title').text('Editar Bebida'); // 👈 agrega texto al título del modal
            let id = $(this).data('id');
            $.get('/admin/bebidas/' + id + '/edit', function(res) {
                $('#bebida_id').val(res.id);
                $('#carta_id').val(res.carta_id);
                $('#sub_carta_id').val(res.sub_carta_id);
                $('#orden').val(res.orden);
                $('#activo').prop('checked', res.activo);

                // Imagen
                if (res.imagen) {
                    $('#imagen-preview').html('<img src="' + res.imagen +
                        '" class="img-thumbnail" width="150">');
                    $('#eliminar-imagen-container').show();
                } else {
                    $('#imagen-preview').html('');
                    $('#eliminar-imagen-container').hide();
                }

                // Traducciones
                $.each(res.translations, function(locale, t) {
                    $('#nombre_' + locale).val(t.nombre);
                    $('#descripcion_' + locale).val(t.descripcion);
                });

                // Precios 👇
                $('#precio_copa').val(res.precios.copa);
                $('#precio_vaso').val(res.precios.vaso);
                $('#precio_botella').val(res.precios.botella);
                $('#precio_chupito').val(res.precios.chupito);

                $('#bebidaModal').modal('show');
            });

        });

        // Guardar
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\PAN82\htdocs\manu\resources\views/bebidas/index.blade.php ENDPATH**/ ?>