@extends('adminlte::page')

@section('title', 'Ordenar Sub Cartas' . ' | ' . config('app.name'))

@section('content_header')
    <div class="w-100">
        @php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'SubCartas', 'route' => 'subcartas.index'],
                ['name' => 'Ordenar Sub Cartas'],
            ];
        @endphp

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                @foreach ($breadcrumbs as $breadcrumb)
                    @if (isset($breadcrumb['route']))
                        <li class="breadcrumb-item">
                            <a href="{{ route($breadcrumb['route']) }}">
                                @if (isset($breadcrumb['icon']))
                                    <i class="fas {{ $breadcrumb['icon'] }} mr-1"></i>
                                @endif
                                {{ $breadcrumb['name'] }}
                            </a>
                        </li>
                    @else
                        <li class="breadcrumb-item active" aria-current="page">{{ $breadcrumb['name'] }}</li>
                    @endif
                @endforeach
            </ol>
        </nav>
    </div>
@stop

@section('content')

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Ordenar Sub Cartas</h5>
                    </div>

                    <!-- Botón -->

                </div>
            </div>

            <div class="card-body p-2">

                <p class="text-muted">Arrastra y suelta para cambiar el orden de las Sub cartas.</p>

                @foreach ($cartas as $carta)
                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-primary text-white d-flex align-items-center">
                            <i class="fa-solid fa-layer-group me-2"></i>
                            {{ $carta->translate(app()->getLocale())->nombre }}
                        </div>
                        <ul class="list-group list-group-flush sortable" data-carta-id="{{ $carta->id }}">
                            @foreach ($carta->subCartas as $sub)
                                <li class="list-group-item d-flex align-items-center" data-id="{{ $sub->id }}">
                                    <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary"></i>
                                    {{ $sub->translate(app()->getLocale())->nombre }}
                                    @if (!$sub->activo)
                                        <span class="badge bg-danger ms-auto"><i class="fa-solid fa-ban"></i>
                                            Inactivo</span>
                                    @endif
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endforeach

                <div class="mt-3">
                    <button id="guardarOrden" class="btn btn-success">
                        <i class="fa-solid fa-floppy-disk"></i> Guardar Orden
                    </button>
                </div>

            </div>
        </div>
    </div>





@stop

@section('css')
<style>
    ul.sortable {
    list-style: none;
    padding-left: 0;
    margin: 0;
}
.sortable li {
    cursor: grab; /* cuando está quieto */
}
.sortable li:active {
    cursor: grabbing; /* cuando lo arrastras */
}
</style>
@stop

@push('js')
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script>
        // Activar sortable en cada lista de subcartas
        $(function() {
            $(".sortable").sortable({
                placeholder: "ui-state-highlight"
            }).disableSelection();

            $('#guardarOrden').click(function() {
                let orden = {};

                $(".sortable").each(function() {
                    let cartaId = $(this).data('carta-id');
                    let subOrden = [];
                    $(this).find('li').each(function() {
                        subOrden.push($(this).data('id'));
                    });
                    orden[cartaId] = subOrden;
                });

                $.ajax({
                    url: "{{ route('subcartas.ordenar.guardar') }}",
                    method: "POST",
                    data: {
                        orden: orden,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(resp) {
                        if (resp.success) {
                            Toast.fire({
                                icon: 'success',
                                title: 'Orden guardado correctamente'
                            });
                        }
                    },
                    error: function() {
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al guardar el orden'
                        });
                    }
                });
            });
        });
    </script>
@endpush
