<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    {{-- CSRF Token --}}
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {{-- Title dinámico --}}
    <title>
        @hasSection('title')
            @yield('title') | {{ config('app.name', env('APP_NAME', 'Laravel')) }}
        @else
            {{ config('app.name', env('APP_NAME', 'Laravel')) }}
        @endif
    </title>

    {{-- Meta Description dinámica --}}
    <meta name="description" content="@yield('meta_description', config('app.description', 'Bienvenido a ' . config('app.name')))">

    {{-- Open Graph para SEO y redes sociales --}}
    <meta property="og:title" content="@yield('title', config('app.name'))">
    <meta property="og:description" content="@yield('meta_description', config('app.description', 'Bienvenido a ' . config('app.name')))">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:image" content="@yield('meta_image', asset('images/default-og.png'))">

    {{-- Bootstrap 5.3 (CDN) --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    {{-- Fonts --}}
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet">

    {{-- Vite assets --}}
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    {{-- Extra styles --}}
    @stack('styles')
</head>
<body class="bg-light">
    <div class="min-vh-100 d-flex flex-column">
        
        {{-- Navbar --}}
        @include('layouts.navigation')

        {{-- Header opcional --}}
        @isset($header)
            <header class="bg-white shadow-sm">
                <div class="container py-4">
                    {{ $header }}
                </div>
            </header>
        @endisset

        {{-- Main Content --}}
        <main class="flex-fill container my-4">
            {{ $slot ?? '' }}
            @yield('content')
        </main>

        {{-- Footer --}}
        <footer class="bg-dark text-white py-3 mt-auto">
            <div class="container text-center">
                <small>&copy; {{ date('Y') }} {{ config('app.name') }}. Todos los derechos reservados.</small>
            </div>
        </footer>
    </div>

    {{-- Bootstrap JS + Popper --}}
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    {{-- Extra scripts --}}
    @stack('js')
</body>
</html>
