@extends('layouts.app')

@section('title', $title)
@section('meta_description', $description)

@section('content')
<div class="container py-5">
    <div class="row align-items-center">
        <div class="col-lg-6 mb-4 mb-lg-0">
            <h1 class="display-4 fw-bold text-primary">{{ config('app.name') }}</h1>
            <p class="lead text-muted">
                {{ $description }}
            </p>
            <a href="{{ route('home') }}" class="btn btn-primary btn-lg rounded-pill shadow-sm mt-3">
                Empezar ahora
            </a>
        </div>
        <div class="col-lg-6">
            <img src="https://picsum.photos/600/400" class="img-fluid rounded-3 shadow" alt="Hero Image">
        </div>
    </div>
</div>

<div class="container py-5">
    <div class="row text-center">
        <div class="col-md-4 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <h5 class="card-title">Sección 1</h5>
                    <p class="card-text">Texto breve de la sección uno.</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <h5 class="card-title">Sección 2</h5>
                    <p class="card-text">Texto breve de la sección dos.</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <h5 class="card-title">Sección 3</h5>
                    <p class="card-text">Texto breve de la sección tres.</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script>
    document.addEventListener("DOMContentLoaded", function() {
        console.log("Home cargado correctamente 🚀");
    });
</script>
@endpush
