@extends('adminlte::page')

@section('title', 'Ordenar Alergenos' . ' | ' . config('app.name'))

@section('content_header')
    <div class="w-100">
        @php
            $breadcrumbs = [
                ['name' => 'Inicio', 'route' => 'dashboard', 'icon' => 'fa-home'],
                ['name' => 'Alergenos', 'route' => 'alergenos.index'],
                ['name' => 'Ordenar Alergenos'],
            ];
        @endphp

        <nav aria-label="breadcrumb">
            <ol class="breadcrumb bg-light p-2 rounded shadow-sm">
                @foreach ($breadcrumbs as $breadcrumb)
                    @if (isset($breadcrumb['route']))
                        <li class="breadcrumb-item">
                            <a href="{{ route($breadcrumb['route']) }}">
                                @if (isset($breadcrumb['icon']))
                                    <i class="fas {{ $breadcrumb['icon'] }} mr-1"></i>
                                @endif
                                {{ $breadcrumb['name'] }}
                            </a>
                        </li>
                    @else
                        <li class="breadcrumb-item active" aria-current="page">{{ $breadcrumb['name'] }}</li>
                    @endif
                @endforeach
            </ol>
        </nav>
    </div>
@stop

@section('content')

    <div class="m-0">
        <div class="card shadow-sm">
            <div class="card-header">
                <div class="row align-items-center">
                    <!-- Título -->
                    <div class="col-12 col-md-6">
                        <h5 class="mb-md-0">Ordenar Alergenos</h5>
                    </div>

                    <!-- Botón -->

                </div>
            </div>

            <div class="card-body p-2">

                <p class="text-muted">Arrastra y suelta para cambiar el orden de los alergenos.</p>

                <ul id="sortable" class="list-group sortable">
                    @foreach ($alergenos as $alergeno)
                        <li class="list-group-item d-flex align-items-center" data-id="{{ $alergeno->id }}">
                            <i class="fa-solid fa-arrows-alt fa-lg me-3 text-secondary drag-handle"></i>
                            {{ $alergeno->translate(app()->getLocale())->nombre }}
                            @if (!$alergeno->activo)
                                <span class="badge bg-danger ms-auto"><i class="fa-solid fa-ban"></i> Inactivo</span>
                            @endif
                        </li>
                    @endforeach
                </ul>

                <div class="mt-3">
                    <button id="guardarOrden" class="btn btn-success">
                        <i class="fa-solid fa-floppy-disk"></i> Guardar Orden
                    </button>
                </div>
            </div>
        </div>
    </div>





@stop

@section('css')
    <style>
        ul.sortable {
            list-style: none;
            padding-left: 0;
            margin: 0;
        }

        .sortable li {
            cursor: grab;
            /* cuando está quieto */
        }

        .sortable li:active {
            cursor: grabbing;
            /* cuando lo arrastras */
        }
    </style>
@stop

@push('js')
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
    <script>
        $(function() {
            $("#sortable").sortable({
                placeholder: "ui-state-highlight",
                handle: ".drag-handle",
                cursor: "grabbing"
            }).disableSelection();

            $('#guardarOrden').click(function() {
                let orden = [];
                $('#sortable li').each(function() {
                    orden.push($(this).data('id'));
                });

                $.ajax({
                    url: "{{ route('alergenos.ordenar.guardar') }}",
                    method: "POST",
                    data: {
                        orden: orden,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(resp) {
                        if (resp.success) {
                            Toast.fire({
                                icon: 'success',
                                title: 'Orden guardado correctamente'
                            });
                        }
                    },
                    error: function() {
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al guardar el orden'
                        });
                    }
                });
            });
        });
    </script>
@endpush
