@extends('adminlte::page')

@section('title', 'Dashboard')

@section('content_header')
    <h1>Dashboard</h1>
@stop

@section('content')
    <style>
        /* Área Dropzone personalizada */
        .dropzone {
            border: 2px dashed #6c757d;
            /* borde gris punteado */
            border-radius: 8px;
            background: #f8f9fa;
            /* fondo suave */
            padding: 20px 10px;
            text-align: center;
            position: relative;
        }

        /* Icono central */
        .dropzone .dz-message {
            font-size: 1rem;
            color: #6c757d;
            font-weight: 500;
        }

        /* Icono grande encima del texto */
        .dropzone .dz-message::before {
            content: "\f302";
            /* FontAwesome icon: images */
            font-family: "Font Awesome 5 Free";
            font-weight: 900;
            /* solid */
            display: block;
            font-size: 2rem;
            color: #6c757d;
            margin-bottom: 10px;
        }
    </style>
    <div class="container-fluid">

        <div class="card mb-4 shadow-sm">
            <div class="row no-gutters">
                <!-- Imagen de portada -->
                <div class="col-md-2">
                    <img src="{{ $gallery->cover_image ? asset($gallery->cover_image) : asset('images/no_image.jpg') }}"
                        class="card-img" alt="{{ $gallery->title }}">
                </div>

                <!-- Información principal -->
                <div class="col-md-9">
                    <div class="card-body">
                        <h3 class="card-title mb-2">{{ $gallery->title }}</h3>

                        @if ($gallery->description)
                            <p class="card-text text-muted">{{ $gallery->description }}</p>
                        @endif

                        <div class="d-flex flex-wrap align-items-center">
                            <!-- Status -->
                            @if ($gallery->status)
                                <span class="badge badge-primary mr-2 mb-2">
                                    <i class="fas fa-eye"></i> Publicado
                                </span>
                            @else
                                <span class="badge badge-secondary mr-2 mb-2">
                                    <i class="fas fa-eye-slash"></i> Borrador
                                </span>
                            @endif

                            <!-- Views -->
                            <span class="badge badge-info mr-2 mb-2">
                                <i class="fas fa-chart-line"></i> {{ $gallery->views }}
                            </span>

                            <!-- Fecha de creación -->
                            <span class="badge badge-dark mb-2">
                                <i class="fas fa-calendar-alt"></i> {{ $gallery->created_at->format('d-m-Y H:i') }}
                            </span>
                        </div>

                        <!-- Opcional: botones de acción -->
                        <div class="mt-3">
                            <a href="{{ route('admin.galleries.photos.index', $gallery->id) }}"
                                class="btn btn-success btn-sm">
                                <i class="fas fa-images"></i> Gestionar Fotos
                            </a>
                            {{--  <a href="{{ route('admin.galleries.edit', $gallery->id) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> Editar Galería
                            </a> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="row">
            <!-- Columna para imágenes antiguas -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-info text-white">
                        Fotos Antiguas
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.galleries.photos.upload', $gallery->id) }}" class="dropzone"
                            id="dropzoneOld">
                            @csrf
                            <input type="hidden" name="type" value="old">
                            <div class="dz-message">Arrastra imágenes antiguas o haz clic para subir</div>
                        </form>

                        <!-- Contenedor exclusivo para fotos antiguas -->
                        <div id="photosOldGallery" class="row mt-3"></div>
                    </div>
                </div>
            </div>

            <!-- Columna para imágenes actuales -->
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-success text-white">
                        Fotos Actuales
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.galleries.photos.upload', $gallery->id) }}" class="dropzone"
                            id="dropzoneCurrent">
                            @csrf
                            <input type="hidden" name="type" value="current">
                            <div class="dz-message">Arrastra imágenes actuales o haz clic para subir</div>
                        </form>

                        <!-- Contenedor exclusivo para fotos actuales -->
                        <div id="photosCurrentGallery" class="row mt-3"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>





@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@push('js')
    <script>
        Dropzone.autoDiscover = false;

        function initDropzone(dropzoneId, containerId, type) {
            new Dropzone("#" + dropzoneId, {
                paramName: "file",
                maxFilesize: 5,
                acceptedFiles: "image/*",
                addRemoveLinks: true,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                init: function() {
                    this.on("success", function(file, response) {
                        if (response.photo) {
                            const photo = response.photo;
                            const html = `
                                    <div class="col-6 col-md-4 mb-3" id="photo-${photo.id}">
                                        <div class="card position-relative h-100 d-flex flex-column">
                                            <div class="overflow-hidden" style="height:150px; display:flex; align-items:center; justify-content:center;">
                                                <img src="{{ asset('') }}${photo.image_path}" class="card-img-top img-fluid" alt="${photo.title}" 
                                                    style="object-fit: cover; width:100%;">
                                            </div>
                                            <div class="card-body p-2 flex-grow-1 d-flex align-items-center justify-content-center">
                                                <span class="text-truncate" title="${photo.title ?? ''}">${photo.title ?? ''}</span>
                                            </div>
                                            <button class="btn btn-sm btn-danger position-absolute" style="top:5px; right:5px;" 
                                                    onclick="deletePhoto(${photo.id})">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>`;
                            /* const html = `
                        <div class="col-md-3 mb-3" id="photo-${photo.id}">
                            <div class="card">
                                <img src="{{ asset('') }}${photo.image_path}" class="card-img-top" alt="${photo.title}">
                                <div class="card-body p-2">
                                    <p class="mb-1"><strong>${photo.title ?? ''}</strong></p>
                                    <small class="text-muted">${photo.type}</small>
                                </div>
                            </div>
                        </div>`; */
                            // Agrega solo al contenedor correspondiente
                            $('#' + containerId).prepend(html);
                        }

                        // Limpiar el archivo del Dropzone después de subir
                        this.removeFile(file);
                    });
                }
            });
        }

        // Inicialización
        initDropzone('dropzoneOld', 'photosOldGallery', 'old');
        initDropzone('dropzoneCurrent', 'photosCurrentGallery', 'current');
    </script>

    <script>
        function loadExistingPhotos(galleryId) {
            $.getJSON("/admin/galleries/" + galleryId + "/photos/list", function(data) {
                $('#photosOldGallery').empty();
                $('#photosCurrentGallery').empty();

                data.forEach(function(photo) {
                    const html = `
                        <div class="col-6 col-md-4 mb-3" id="photo-${photo.id}">
                            <div class="card position-relative h-100 d-flex flex-column">
                                <div class="overflow-hidden" style="height:150px; display:flex; align-items:center; justify-content:center;">
                                    <img src="${photo.image_path}" class="card-img-top img-fluid" alt="${photo.title}" 
                                        style="object-fit: cover; width:100%;">
                                </div>
                                <div class="card-body p-2 flex-grow-1 d-flex align-items-center justify-content-center">
                                    <span class="text-truncate" title="${photo.title ?? ''}">${photo.title ?? ''}</span>
                                </div>
                                <button class="btn btn-sm btn-danger position-absolute" style="top:5px; right:5px;" 
                                        onclick="deletePhoto(${photo.id})">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>`;



                    if (photo.type === 'old') {
                        $('#photosOldGallery').append(html);
                    } else {
                        $('#photosCurrentGallery').append(html);
                    }
                });
            });
        }

        // Llamar al cargar la página
        $(document).ready(function() {
            const galleryId = {{ $gallery->id }};
            loadExistingPhotos(galleryId);
        });
    </script>

    <script>
        let destroyUrlTemplate = "{{ route('admin.galleries.photos.destroy', ':id') }}";

        function deletePhoto(photoId) {
            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción eliminará la imagen permanentemente.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    let url = destroyUrlTemplate.replace(':id', photoId);

                    $.ajax({
                        url: url,
                        type: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        success: function(res) {
                            if (res.success) {
                                // primero quitamos visualmente
                                $("#photo-" + photoId).fadeOut(400, function() {
                                    $(this).remove();
                                });

                                // luego mostramos alerta de éxito
                                Swal.fire({
                                    title: 'Eliminado',
                                    text: 'La imagen ha sido eliminada.',
                                    icon: 'success',
                                    timer: 1500,
                                    showConfirmButton: false
                                });
                            }
                        },
                        error: function() {
                            Swal.fire('Error', 'No se pudo eliminar la imagen.', 'error');
                        }
                    });
                }
            });
        }
    </script>
@endpush
