@extends('adminlte::page')

@section('title', 'Dashboard')

@section('content_header')
    <h1>Dashboard</h1>
@stop

@section('content')
    <div class="container_ab">
        <button class="btn btn-success mb-2" id="createNewGallery">Agregar Galería</button>
        <table class="table table-striped table-bordered table-sm" id="galleriesTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Cover</th>
                    <th>Título</th>
                    <th>Estado</th>
                    <th style="width: 14%">Acciones</th>
                </tr>
            </thead>
        </table>
    </div>

    <!-- Modal único -->
    <div class="modal fade" id="galleryModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <form id="galleryForm" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar/Editar Galería</h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" id="galleryId">

                        <div class="row">
                            <!-- Columna izquierda: Dropzone imagen -->
                            <div class="col-md-4">
                                <label>Cover</label>
                                <div id="dropzoneCover" class="dropzone text-center"
                                    style="border: 2px dashed #007bff; padding: 20px;">
                                    <div class="dz-message">Arrastra o haz clic para subir imagen</div>
                                </div>
                            </div>

                            <!-- Columna derecha: datos de la galería -->
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Título</label>
                                    <input type="text" name="title" id="title" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label>Descripción</label>
                                    <textarea name="description" id="description" class="form-control"></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Status</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="1">Publicado</option>
                                        <option value="0">Borrador</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Guardar</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>




@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@push('js')
    <script>
        $(function() {
            // DataTable
            var table = $('#galleriesTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.galleries.index') }}",
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'cover_image',
                        name: 'cover_image',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'title',
                        name: 'title'
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    },
                ]
            });



            // Abrir modal para crear
            $('#createNewGallery').click(function() {
                $('#galleryForm').trigger("reset");
                $('#galleryId').val('');
                $('#galleryModal').modal('show');
            });




            // Eliminar
            $('body').on('click', '.deleteGallery', function() {
                var id = $(this).data('id');
                Swal.fire({
                    title: '¿Eliminar galería?',
                    text: "No podrás revertir esto",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Sí, eliminar!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ url('admin/galleries') }}/" + id,
                            type: "DELETE",
                            data: {
                                _token: "{{ csrf_token() }}"
                            },
                            success: function(data) {
                                Swal.fire('Eliminado!', data.success, 'success');
                                table.ajax.reload();
                            }
                        });
                    }
                });
            });


        });
    </script>

<script>
// ====== CONFIG INICIAL ======
Dropzone.autoDiscover = false;
window.coverDZ = null;

// Base URL pública (Blade la resuelve). Útil si tu BD guarda rutas relativas.
const BASE_URL = "{{ rtrim(asset(''), '/') }}/";
function toAbsoluteUrl(path){
    if (!path) return null;
    if (/^https?:\/\//i.test(path)) return path;         // ya es absoluta
    return path.charAt(0) === '/' ? BASE_URL + path.slice(1) : BASE_URL + path;
}

// ====== REINICIO DURO + RECONSTRUCCIÓN ======
function hardRebuildCoverDropzone(existingImageUrl = null) {
    // 1) Destruye instancia previa si existe
    try {
        if (window.coverDZ) {
            window.coverDZ.destroy();
        } else {
            // por si acaso existe una instancia “huérfana”
            const prev = Dropzone.forElement('#dropzoneCover');
            if (prev) prev.destroy();
        }
    } catch (e) {}

    // 2) Reemplaza completamente el contenedor para borrar clases/HTML de Dropzone
    const oldNode = document.getElementById('dropzoneCover');
    if (!oldNode) return; // contenedor no existe en el DOM
    const newNode = oldNode.cloneNode(false); // sin hijos
    newNode.className = oldNode.className.replace(/\bdz-\S+\b/g, ''); // quita clases dz-*
    newNode.innerHTML = '<div class="dz-message">Arrastra o haz clic para subir</div>';
    oldNode.parentNode.replaceChild(newNode, oldNode);

    // 3) Inicializa una instancia totalmente nueva
    window.coverDZ = new Dropzone('#dropzoneCover', {
        url: "#",                       // no subimos aquí; se envía en el submit del form
        autoProcessQueue: false,
        paramName: "cover_image",
        maxFiles: 1,
        maxFilesize: 5,                 // MB
        acceptedFiles: "image/*",
        addRemoveLinks: true,
        headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" },
        init: function() {
            const dz = this;

            // si agregan un segundo archivo, reemplaza el anterior
            dz.on('maxfilesexceeded', function(file){
                dz.removeAllFiles(true);
                dz.addFile(file);
            });

            // Precarga de imagen existente (modo edición)
            if (existingImageUrl) {
                const abs = toAbsoluteUrl(existingImageUrl);
                const mock = { name: abs.split('/').pop(), size: 12345, accepted: true };
                if (typeof dz.displayExistingFile === 'function') {
                    dz.displayExistingFile(mock, encodeURI(abs));
                } else {
                    dz.emit('addedfile', mock);
                    dz.emit('thumbnail', mock, encodeURI(abs));
                    dz.emit('complete', mock);
                }
                mock.status = Dropzone.SUCCESS; // marcar como existente
                mock.existing = true;
                dz.files.push(mock);
            }
        }
    });
}

// ====== HOOKS DEL MODAL ======

// NUEVO
$('#createNewGallery').on('click', function () {
    $('#galleryForm')[0].reset();
    $('#galleryId').val('');
    hardRebuildCoverDropzone(null);      // <-- SIEMPRE limpio
    $('#galleryModal').modal('show');
});

// EDITAR
$('body').on('click', '.editGallery', function () {
    const id = $(this).data('id');
    $.get("{{ url('admin/galleries') }}/" + id + "/edit", function (data) {
        $('#galleryId').val(data.id);
        $('#title').val(data.title);
        $('#description').val(data.description);
        $('#status').val(data.status);

        // Usa URL absoluta si tu controlador la envía como cover_image_url;
        // si no, caemos al campo cover_image (relativo) y lo convertimos.
        const img = data.cover_image_url ?? data.cover_image ?? null;

        hardRebuildCoverDropzone(img);
        $('#galleryModal').modal('show');
    });
});

// (Opcional) al cerrar, destruye totalmente la instancia
$('#galleryModal').on('hidden.bs.modal', function () {
    try { if (window.coverDZ) { window.coverDZ.destroy(); window.coverDZ = null; } } catch(e){}
});


// ====== SUBMIT DEL FORM: adjunta SOLO archivo nuevo (no el mock) ======
$('#galleryForm').on('submit', function(e){
    e.preventDefault();
    const formData = new FormData(this);

    // Solo archivos NUEVOS (no los marcados como existing)
    if (window.coverDZ) {
        const newFiles = window.coverDZ.getAcceptedFiles()
            .filter(f => !f.existing && (f.status === Dropzone.ADDED || f.status === Dropzone.QUEUED));
        if (newFiles.length > 0) {
            formData.append('cover_image', newFiles[0]);
        }
    }

    $.ajax({
        url: "{{ route('admin.galleries.store') }}",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        success: function(res){
            Swal.fire({icon:'success', title: res.success});
            $('#galleryModal').modal('hide');
            $('#galleriesTable').DataTable().ajax.reload(null, false);
        },
        error: function(){
            Swal.fire({icon:'error', title:'Error', text:'Revisa los campos.'});
        }
    });
});
</script>

@endpush
