<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class SubCartaLang extends Model
{
    protected $table = 'sub_carta_langs';
    public $timestamps = false;

    protected $fillable = [
        'sub_carta_id',
        'locale',
        'nombre',
        'slug',
        'descripcion',
    ];

    use HasSlug;

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('nombre')
            ->saveSlugsTo('slug');
    }

    // 👇 Mejor en camelCase
    public function subCarta()
    {
        return $this->belongsTo(SubCarta::class, 'sub_carta_id');
    }
}
