<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class CartaLang extends Model
{
    use HasSlug;

    protected $fillable = ['carta_id', 'locale', 'nombre', 'descripcion', 'slug'];

    public function carta()
    {
        return $this->belongsTo(Carta::class);
    }

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('nombre')
            ->saveSlugsTo('slug')
            ->doNotGenerateSlugsOnUpdate(); // evita cambios al editar el nombre
    }
}
