<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Astrotomic\Translatable\Translatable;

class Alergeno extends Model
{
    use SoftDeletes, Translatable;

    protected $table = 'alergenos';
    protected $fillable = ['orden', 'activo'];
    public $translatedAttributes = ['nombre', 'descripcion'];
    
    // Especificar la clase de traducción personalizada
    public $translationModel = \App\Models\AlergenoLang::class;
    public $translationForeignKey = 'alergeno_id';
    
    /**
     * Relación con las traducciones
     */
    public function translations()
    {
        return $this->hasMany(AlergenoLang::class);
    }
    
    /**
     * Scope para elementos activos
     */
    public function scopeActivo($query)
    {
        return $query->where('activo', true);
    }
    
    /**
     * Scope para ordenar por orden
     */
    public function scopeOrdenado($query)
    {
        return $query->orderBy('orden', 'asc');
    }

}