<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\User;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index()
    {
        return view('users.index');
    }

    public function data()
    {
        $users = User::select('id', 'name', 'email', 'created_at');

        return DataTables::of($users)
            ->editColumn('created_at', function ($u) {
                return \Carbon\Carbon::parse($u->created_at)->format('d-m-Y H:i');
            })
            ->addColumn('actions', function ($u) {
            return '
                <button class="btn btn-sm btn-primary editUser" data-id="' . $u->id . '">
                    <i class="fas fa-edit"></i> 
                </button>
                <button class="btn btn-sm btn-danger deleteUser" data-id="' . $u->id . '">
                    <i class="fas fa-trash-alt"></i> 
                </button>
                ';

            })
            ->rawColumns(['actions'])
            ->make(true);
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email,' . $request->id,
            'password' => $request->id ? 'nullable|min:6' : 'required|min:6'
        ]);

        $data = $request->only('name', 'email');
        if ($request->password) {
            $data['password'] = Hash::make($request->password);
        }

        User::updateOrCreate(['id' => $request->id], $data);

        return response()->json(['success' => 'Usuario guardado correctamente']);
    }

    public function destroy($id)
    {
        User::findOrFail($id)->delete();
        return response()->json(['success' => 'Usuario eliminado']);
    }

    public function edit($id)
    {
        return response()->json(User::findOrFail($id));
    }
}
