<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ProfilePasswordController extends Controller
{
    public function edit()
    {
        return view('admin.profile.edit-password');
    }

    public function update(Request $request)
    {
        $request->validate([
            'current_password' => ['required'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
        /**
         * @var \App\Models\User $user
         */
        $user = Auth::user();

        // Verificar contraseña actual
        if (!Hash::check($request->current_password, $user->password)) {
            return back()->withErrors(['current_password' => 'La contraseña actual no es correcta']);
        }

        // Actualizar nueva contraseña
        $user->update([
            'password' => Hash::make($request->password),
        ]);

        return redirect()->route('profile.password.edit')->with('success', 'Contraseña actualizada correctamente.');
    }
}
